/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos.conwip;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.util.Comparators;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;

class GorInternalPropertyComparator
implements Comparator<GeneralizedOrderRequest> {
    private final LoadingCache<Object, Comparable<?>> valueCache;
    private final String propertyName;

    GorInternalPropertyComparator(String propertyName) {
        PropertyDescriptor propDesc;
        this.propertyName = propertyName;
        try {
            propDesc = new PropertyDescriptor(propertyName, GeneralizedOrderRequest.class);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        Preconditions.checkNotNull(propDesc, "GOR doesn't have property %s", (Object)propertyName);
        final Method readMethod = propDesc.getReadMethod();
        this.valueCache = CacheBuilder.newBuilder().build(new CacheLoader<Object, Comparable<?>>(){

            @Override
            public Comparable load(@Nonnull Object key) throws Exception {
                return (Comparable)readMethod.invoke(key, new Object[0]);
            }
        });
    }

    @Override
    public int compare(GeneralizedOrderRequest o1, GeneralizedOrderRequest o2) {
        try {
            Comparable<?> c1 = this.valueCache.get(o1);
            Comparable<?> c2 = this.valueCache.get(o2);
            return Comparators.compareNullsLast(c1, c2);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Extraction of GOR property " + this.propertyName + " failed.", e);
        }
    }
}

